var myLatLng = { lat: 6.68209484853092, lng: 80.32611376175865 };

var mapOptions = {
    center: myLatLng,
    zoom: 10,
    mapTypeId: google.maps.MapTypeId.ROADMAP,
};

// Create map
var map = new google.maps.Map(document.getElementById("googleMap"), mapOptions);

/**
 * Direction service object
 */
var directionsService = new google.maps.DirectionsService();

/**
 * Render the direction object
 */
var directionsDisplay = new google.maps.DirectionsRenderer();

/**
 * Display the directions on the map by binding the directions service to the map service
 */
directionsDisplay.setMap(map);

// Initialize an array to store destination input elements
var destinationInputs = [];

// Function to add a new destination input field
function addDestinationInput() {
    // Create a new input element
    var inputElement = document.createElement("input");
    inputElement.type = "text";
    inputElement.className = "form-control";
    inputElement.placeholder = "Destination " + (destinationInputs.length + 1);

    // Append the input element to the form
    var form = document.querySelector(".form-horizontal");
    var formGroup = document.createElement("div");
    formGroup.className = "form-group";
    var label = document.createElement("label");
    label.className = "col-xs-2 control-label";
    var icon = document.createElement("i");
    icon.className = "fas fa-map-marker-alt";
    label.appendChild(icon);
    var divCol = document.createElement("div");
    divCol.className = "col-xs-10";
    divCol.appendChild(inputElement);
    formGroup.appendChild(label);
    formGroup.appendChild(divCol);
    form.appendChild(formGroup);

    // Add the new input element to the destinationInputs array
    destinationInputs.push(inputElement);

    // Add autocomplete to the new input element
    var options = {
        componentRestrictions: { country: "LK" }, // Restrict to Sri Lanka
    };
    var autocomplete = new google.maps.places.Autocomplete(
        inputElement,
        options
    );
}

function calculateDistance() {
    // Creating an array to store waypoints (additional destinations)
    var waypoints = [];

    // Get the origin value
    var origin = document.getElementById("origin").value;

    // Get the values of all destination input elements
    for (var i = 0; i < destinationInputs.length; i++) {
        var destination = destinationInputs[i].value;
        if (destination) {
            waypoints.push({
                location: destination,
                stopover: true,
            });
        }
    }

    // Set the destination as the last waypoint
    var destination = waypoints[waypoints.length - 1];

    // Create the request object with origin, destination, and waypoints
    var request = {
        origin: origin,
        destination: destination.location, // Use the last waypoint as the destination
        waypoints: waypoints.slice(0, -1), // Remove the last waypoint from the waypoints array
        travelMode: google.maps.TravelMode.DRIVING,
        unitSystem: google.maps.UnitSystem.IMPERIAL,
    };

    directionsService.route(request, function (result, status) {
        if (status == google.maps.DirectionsStatus.OK) {
            // Initialize variables to store total distance and duration
            var totalDistance = 0;
            var totalDuration = 0;

            // Initialize variables to store distances between destinations
            var distancesText = "";

            // Loop through each leg of the route
            for (var i = 0; i < result.routes[0].legs.length; i++) {
                var leg = result.routes[0].legs[i];

                // Accumulate the distance and duration for each leg
                totalDistance += leg.distance.value; // Value is in meters
                totalDuration += leg.duration.value; // Value is in seconds

                // Display distances between destinations
                if (i < waypoints.length) {
                    distancesText +=
                        "Destination " +
                        (i + 1) +
                        " to Destination " +
                        (i + 2) +
                        ": " +
                        leg.distance.text +
                        "<br>";
                }
            }

            // Convert total distance and duration to user-friendly formats
            var totalDistanceText = (totalDistance / 1000).toFixed(2) + " km"; // Convert meters to kilometers
            var totalDurationText = formatDuration(totalDuration); // Format duration

            // Display the total distance and duration
            const output = document.querySelector("#output");
            output.innerHTML =
                "<p class='alert-success'>From: " +
                origin +
                "</br>" +
                "Total Distance <i class='fas fa-road'></i> : " +
                totalDistanceText +
                "</br>" +
                "Total Duration <i class='fas fa-clock'></i> : " +
                totalDurationText +
                ".</p>";

            // Display distances between destinations
            document.getElementById("distances").innerHTML = distancesText;

            // Display the obtained route
            directionsDisplay.setDirections(result);
        } else {
            // Handle error
            directionsDisplay.setDirections({ routes: [] });
            map.setCenter(myLatLng);
            const output = document.querySelector("#output");
            output.innerHTML =
                "<div class='alert-danger'><i class='fas fa-exclamation-triangle'></i> Could not retrieve driving distance.</div>";
        }
    });
}

// Function to format duration in hours and minutes
function formatDuration(durationInSeconds) {
    var hours = Math.floor(durationInSeconds / 3600);
    var minutes = Math.floor((durationInSeconds % 3600) / 60);

    if (hours === 0) {
        return minutes + " min";
    } else {
        return hours + " hr " + minutes + " min";
    }
}
var originInput = document.getElementById("origin");
var options = {
    componentRestrictions: { country: "LK" }, // Restrict to Sri Lanka
};
var originAutocomplete = new google.maps.places.Autocomplete(
    originInput,
    options
);
